---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-フォームレイアウト（Bootstrap 4 水平）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_4_horizontal_layout.html.twig` L1-93
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_4_layout.html.twig` L1-324
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行49（No.48のエントリ）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行122-123（No.48の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bootstrap_4_layoutをuseタグで読み込む | E-01 L1 | ○ |
| C-02 | form_labelにcol-form-labelとcol-sm-2を適用 | E-01 L5-15 | ○ |
| C-03 | label=falseで空div.col-sm-2を出力 | E-01 L6-7 | ○ |
| C-04 | form_label_classがcol-sm-2 | E-01 L17-19 | ○ |
| C-05 | form_rowでexpanded判定・通常行とfieldset行の振り分け | E-01 L23-43 | ○ |
| C-06 | fieldset_form_rowでfieldset/legend/div.row構造 | E-01 L45-60 | ○ |
| C-07 | submit_rowでform-group row + 空ラベル列 + フィールド列 | E-01 L62-69 | ○ |
| C-08 | reset_rowでsubmit_rowと同構造 | E-01 L71-78 | ○ |
| C-09 | form_group_classがcol-sm-10 | E-01 L80-82 | ○ |
| C-10 | checkbox_rowで水平チェックボックス配置 | E-01 L84-92 | ○ |
| C-11 | form-group rowクラスの組み合わせ使用 | E-01 L35 | ○ |
| C-12 | is-invalidクラスのフォーム行レベル適用 | E-01 L35 | ○ |
| C-13 | 関連機能：Form、Twig Bridge | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 93行の小規模テンプレートで全行を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] グリッドクラス（col-sm-2 / col-sm-10）が正確か確認
- [ ] expanded要素のfieldset構造が正確か確認
- [ ] Bootstrap 3水平レイアウトとの差分が正確に記述されているか確認
